this.name        = "Super Cobra"; 
this.author      = "eric walch"; 
this.copyright   = " 2008 eric Walch."; 
this.description = "Initialisaton of SC."; 
this.version     = "1.00"; 

this.shipSpawned = function()
{
    this.ship.switchAI("supercobraJSAI.plist")
    this.ship.bounty = Math.round(Math.random()*150 + 15)
    this.mineCount = 3
    this.mineDumped = false
    delete this.shipSpawned;
}

this.shipBeingAttacked = function()
{
 if (this.ship.energy/this.ship.maxEnergy < 0.3) this.ship.reactToAIMessage("ENERGY_LOW");
}

this.shipDied = function()
{
    this.ship.spawn(this.ship.scriptInfo.sc_barrel, Math.ceil(Math.random()*8))
}

this.dumpMine = function()
{
    if(this.mineCount > 0 && Math.random() > 0.8 && !this.mineDumped)
    {
        if(Math.random > 0.95 && this.ship.speed > this.ship.maxSpeed * 0.90) this.mine = this.ship.spawn("energy_bomb")
        else this.mine = this.ship.spawnOne("supercobra_mine") // ejectItem always gives scanClass cargo
        this.mine.setPosition(this.ship.position.subtract(this.ship.heading.multiply(25))) // 25 meter behind ship centre.
        this.mineCount--
        this.mineDumped = true
    }
}

this.resetMine = function()
{
        this.mineDumped = false
}

this.checkDirection = function()
{
    let heading = this.ship.target.heading
    if (this.ship.target == player && 0 < oolite.compareVersion("1.72"))
    {
        let orientation = player.orientation
        orientation.w = -orientation.w
        heading = orientation.vectorForward()
    }
    let angle = this.ship.heading.angleTo(heading)
    if (angle < 0.08 || angle > 3.06) this.ship.reactToAIMessage("CRAZY_EDDY");
}

this.newHeading = function()
{
    let position = this.ship.position.add(this.ship.orientation.vectorUp().multiply(20E3))
    this.setMarker(position)
    this.hostile = this.ship.target
    this.ship.target = this.marker
}

this.resetTarget = function()
{
        this.marker.setPosition(this.marker.position.multiply(100))
        this.ship.target = this.hostile
}

this.setMarker = function(pos)
{
    if(!this.marker || (this.marker && !this.marker.isValid)) this.marker = this.ship.spawnOne("supercobra_marker")
    this.marker.setPosition(pos)
}
